/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

// Energy Field
// By: Brandon Fogerty
// bfogerty at gmail dot com 
// xdpixel.com
// Special thanks to Inigo Quilez for noise!

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 resolution;

float hash( float n ) { return fract(sin(n)*753.5453123); }

// Slight modification of iq's noise function.
float noise( in vec2 x )
{
    vec2 p = floor(x);
    vec2 f = fract(x);
    f = f*f*(3.0-2.0*f);
    
    float n = p.x + p.y*157.0;
    return mix(
                    mix( hash(n+  0.0), hash(n+  1.0),f.x),
                    mix( hash(n+157.0), hash(n+158.0),f.x),
            f.y);
}


float fbm(vec2 p, vec3 a)
{
     float v = 0.0;
     v += noise(p*a.x)*.5;
     v += noise(p*a.y)*.25;
     v += noise(p*a.z)*.125;
     return v;
}

vec3 drawLines( vec2 uv, vec3 fbmOffset, vec3 color1, vec3 color2 )
{
    float timeVal = time * 0.1;
    vec3 finalColor = vec3( 0.0 );
    for( int i=0; i < 5; ++i )
    {
        float indexAsFloat = float(i);
        float amp = 40.0 + (indexAsFloat*5.0);
        float period = 8.0 + (indexAsFloat+1.0);
        float thickness = mix( 0.9, 1.0, noise(uv*10.0) );
        float t = abs( 0.2 / (sin(uv.x + fbm( uv + timeVal * period, fbmOffset )) * amp) * thickness );
        
        finalColor +=  t * color1;
    }
    
    for( int i=0; i < 40; ++i )
    {
        float indexAsFloat = float(i);
        float amp = 30.0 + (indexAsFloat*7.0);
        float period = 8.0 + (indexAsFloat+.001);
        float thickness = mix( 0.7, 1.0, noise(uv*10.0) );
        float t = abs( 0.5 / (sin(uv.x + fbm( uv + timeVal * period, fbmOffset )) * amp) * thickness );
        
        finalColor +=  t * color2 * 0.6;
    }
    
    return finalColor;
}

void main( void ) 
{

    vec2 uv = ( scaled_gl_FragCoord.xy / resolution.xy ) * 2.0 - 1.0;
    uv.x *= resolution.x/resolution.y;
    uv.xy = uv.yx;

    vec3 lineColor1 = vec3( 2.3, 0.5, .5 );
    vec3 lineColor2 = vec3( 0.3, 0.5, 2.5 );
    
    vec3 finalColor = vec3(0.0);

    
    float t = sin( time ) * 0.5 + 0.5;
    float pulse = mix( 0.10, 0.20, t);
    
    finalColor += drawLines( uv, vec3( 1.0, 20.0, 30.0), lineColor1, lineColor2 ) * pulse;
    finalColor += drawLines( uv, vec3( 1.0, 2.0, 4.0), lineColor1, lineColor2 );
    
    gl_FragColor = vec4( finalColor, 1.0 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15

}